/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3d;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientAdvancements;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.montoyo.mcef.api.API;
import net.montoyo.mcef.api.CefInitEvent;
import net.montoyo.mcef.api.IBrowser;
import net.montoyo.mcef.api.IDisplayHandler;
import net.montoyo.mcef.api.IJSQueryCallback;
import net.montoyo.mcef.api.IJSQueryHandler;
import net.montoyo.wd.SharedProxy;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.block.BlockScreen;
import net.montoyo.wd.client.JSQueryDispatcher;
import net.montoyo.wd.client.WDScheme;
import net.montoyo.wd.client.gui.GuiMinePad;
import net.montoyo.wd.client.gui.GuiScreenConfig;
import net.montoyo.wd.client.gui.GuiSetURL2;
import net.montoyo.wd.client.gui.RenderRecipe;
import net.montoyo.wd.client.gui.WDScreen;
import net.montoyo.wd.client.gui.loading.GuiLoader;
import net.montoyo.wd.client.renderers.IItemRenderer;
import net.montoyo.wd.client.renderers.LaserPointerRenderer;
import net.montoyo.wd.client.renderers.MinePadRenderer;
import net.montoyo.wd.client.renderers.ScreenModelLoader;
import net.montoyo.wd.client.renderers.ScreenRenderer;
import net.montoyo.wd.config.ClientConfig;
import net.montoyo.wd.core.HasAdvancement;
import net.montoyo.wd.core.JSServerRequest;
import net.montoyo.wd.data.GuiData;
import net.montoyo.wd.entity.TileEntityScreen;
import net.montoyo.wd.init.BlockInit;
import net.montoyo.wd.init.ItemInit;
import net.montoyo.wd.init.TileInit;
import net.montoyo.wd.item.ItemLaserPointer;
import net.montoyo.wd.item.ItemMinePad2;
import net.montoyo.wd.item.WDItem;
import net.montoyo.wd.miniserv.client.Client;
import net.montoyo.wd.net.WDNetworkRegistry;
import net.montoyo.wd.net.server_bound.C2SMessageMinepadUrl;
import net.montoyo.wd.utilities.BlockSide;
import net.montoyo.wd.utilities.Log;
import net.montoyo.wd.utilities.Multiblock;
import net.montoyo.wd.utilities.NameUUIDPair;
import net.montoyo.wd.utilities.Rotation;
import net.montoyo.wd.utilities.Vector2i;
import net.montoyo.wd.utilities.Vector3i;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mod.EventBusSubscriber(modid="webdisplays", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientProxy
extends SharedProxy
implements IDisplayHandler,
IJSQueryHandler,
ResourceManagerReloadListener {
    private static ClientProxy INSTANCE;
    private Minecraft mc;
    private API mcef;
    private MinePadRenderer minePadRenderer;
    private JSQueryDispatcher jsDispatcher;
    private LaserPointerRenderer laserPointerRenderer;
    private Screen nextScreen;
    private boolean isF1Down;
    private int miniservPort;
    private boolean msClientStarted;
    private final Field advancementToProgressField = ClientProxy.findAdvancementToProgressField();
    private ClientAdvancements lastAdvMgr;
    private Map advancementToProgress;
    private final ArrayList<TileEntityScreen> screenTracking = new ArrayList();
    private int lastTracked = 0;
    private final HashMap<UUID, PadData> padMap = new HashMap();
    private final ArrayList<PadData> padList = new ArrayList();
    private int minePadTickCounter = 0;
    public static final KeyMapping KEY_MOUSE;
    static boolean rDown;
    public static boolean mouseOn;

    public ClientProxy() {
        INSTANCE = this;
    }

    public static void blit(PoseStack p_93229_, int p_93230_, int p_93231_, int p_93232_, int p_93233_, int p_93234_, int p_93235_, int offset) {
        Gui.m_93143_((PoseStack)p_93229_, (int)p_93230_, (int)p_93231_, (int)offset, (float)p_93232_, (float)p_93233_, (int)p_93234_, (int)p_93235_, (int)256, (int)256);
    }

    public static void renderCrosshair(Options options, int screenWidth, int screenHeight, int offset, PoseStack poseStack, CallbackInfo ci) {
        ItemStack stack = Minecraft.m_91087_().f_91074_.m_21120_(InteractionHand.MAIN_HAND);
        ItemStack stack1 = Minecraft.m_91087_().f_91074_.m_21120_(InteractionHand.OFF_HAND);
        if (stack.m_41720_() instanceof ItemMinePad2) {
            sign = 1.0f;
            if (Minecraft.m_91087_().f_91074_.m_5737_() == HumanoidArm.LEFT) {
                sign = -1.0f;
            }
            if (!MinePadRenderer.renderAtSide(sign)) {
                ci.cancel();
                return;
            }
        } else if (stack1.m_41720_() instanceof ItemMinePad2) {
            sign = -1.0f;
            if (Minecraft.m_91087_().f_91074_.m_5737_() == HumanoidArm.LEFT) {
                sign = 1.0f;
            }
            if (!MinePadRenderer.renderAtSide(sign)) {
                ci.cancel();
                return;
            }
        }
        if (!(stack.m_41720_() instanceof ItemLaserPointer) && !(stack1.m_41720_() instanceof ItemLaserPointer)) {
            return;
        }
        if (!LaserPointerRenderer.isOn()) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("webdisplays:textures/gui/cursors.png"));
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            ClientProxy.blit(poseStack, (screenWidth - 15) / 2, (screenHeight - 15) / 2, 240, 240, 15, 15, offset);
            ci.cancel();
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        BlockHitResult result = ClientProxy.raycast(64.0);
        BlockPos bpos = result.m_82425_();
        if (result.m_6662_() != HitResult.Type.BLOCK || mc.f_91073_.m_8055_(bpos).m_60734_() != BlockInit.blockScreen.get()) {
            return;
        }
        Vector3i pos = new Vector3i(result.m_82425_());
        BlockSide side = BlockSide.values()[result.m_82434_().ordinal()];
        Multiblock.findOrigin((LevelAccessor)mc.f_91073_, pos, side, null);
        TileEntityScreen te = (TileEntityScreen)mc.f_91073_.m_7702_(pos.toBlock());
        TileEntityScreen.Screen sc = te.getScreen(side);
        if (sc == null) {
            return;
        }
        int coordX = sc.mouseType * 15;
        int coordY = coordX / 256;
        RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("webdisplays:textures/gui/cursors.png"));
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        ClientProxy.blit(poseStack, (screenWidth - 15) / 2, (screenHeight - 15) / 2, coordX -= coordY * 256, coordY, 15, 15, offset);
        ci.cancel();
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)TileInit.SCREEN_BLOCK_ENTITY.get()), (BlockEntityRendererProvider)new ScreenRenderer.ScreenRendererProvider());
    }

    @SubscribeEvent
    public static void onModelRegistryEvent(ModelEvent.RegisterGeometryLoaders event) {
        event.register(ScreenModelLoader.SCREEN_LOADER.m_135815_(), (IGeometryLoader)new ScreenModelLoader());
    }

    private static void registerBlockRenderLayers(RenderType layer, Block ... blocks) {
        Stream.of(blocks).forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)layer));
    }

    @Override
    public void preInit() {
        super.preInit();
        this.mc = Minecraft.m_91087_();
    }

    @Override
    public void init() {
        super.init();
    }

    @Override
    public void onCefInit(CefInitEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.mcef = event.getApi();
        if (this.mcef != null) {
            this.mcef.registerScheme("wd", WDScheme.class, true, false, false, true, true, false, false);
        }
        this.jsDispatcher = new JSQueryDispatcher(this);
        this.minePadRenderer = new MinePadRenderer();
        this.laserPointerRenderer = new LaserPointerRenderer();
        if (this.mcef == null) {
            throw new RuntimeException("MCEF is missing");
        }
        this.mcef.registerDisplayHandler((IDisplayHandler)this);
        this.mcef.registerJSQueryHandler((IJSQueryHandler)this);
        ClientProxy.findAdvancementToProgressField();
    }

    @Override
    public void postInit() {
        ((ReloadableResourceManager)this.mc.m_91098_()).m_7217_((PreparableReloadListener)this);
    }

    @Override
    public Level getWorld(ResourceKey<Level> dim) {
        ClientLevel ret = this.mc.f_91073_;
        if (ret != null) {
            if (!ret.m_46472_().equals(dim)) {
                throw new RuntimeException("Can't get non-current dimension " + dim + " from client.");
            }
            return ret;
        }
        throw new RuntimeException("Level on client is null");
    }

    @Override
    public void enqueue(Runnable r) {
        this.mc.m_18707_(r);
    }

    @Override
    public void displayGui(GuiData data) {
        Screen gui = data.createGui(this.mc.f_91080_, (Level)this.mc.f_91073_);
        if (gui != null) {
            this.mc.m_91152_(gui);
        }
    }

    @Override
    public void trackScreen(TileEntityScreen tes, boolean track) {
        int idx = -1;
        for (int i = 0; i < this.screenTracking.size(); ++i) {
            if (this.screenTracking.get(i) != tes) continue;
            idx = i;
            break;
        }
        if (track) {
            if (idx < 0) {
                this.screenTracking.add(tes);
            }
        } else if (idx >= 0) {
            this.screenTracking.remove(idx);
        }
    }

    @Override
    public void onAutocompleteResult(NameUUIDPair[] pairs) {
        Screen screen;
        if (this.mc.f_91080_ != null && (screen = this.mc.f_91080_) instanceof WDScreen) {
            WDScreen screen2 = (WDScreen)screen;
            if (pairs.length == 0) {
                screen2.onAutocompleteFailure();
            } else {
                screen2.onAutocompleteResult(pairs);
            }
        }
    }

    @Override
    public GameProfile[] getOnlineGameProfiles() {
        return new GameProfile[]{this.mc.f_91074_.m_36316_()};
    }

    @Override
    public void screenUpdateResolutionInGui(Vector3i pos, BlockSide side, Vector2i res) {
        GuiScreenConfig gsc;
        Screen screen;
        if (this.mc.f_91080_ != null && (screen = this.mc.f_91080_) instanceof GuiScreenConfig && (gsc = (GuiScreenConfig)screen).isForBlock(pos.toBlock(), side)) {
            gsc.updateResolution(res);
        }
    }

    @Override
    public void screenUpdateRotationInGui(Vector3i pos, BlockSide side, Rotation rot) {
        GuiScreenConfig gsc;
        Screen screen;
        if (this.mc.f_91080_ != null && (screen = this.mc.f_91080_) instanceof GuiScreenConfig && (gsc = (GuiScreenConfig)screen).isForBlock(pos.toBlock(), side)) {
            gsc.updateRotation(rot);
        }
    }

    @Override
    public void screenUpdateAutoVolumeInGui(Vector3i pos, BlockSide side, boolean av) {
        GuiScreenConfig gsc;
        Screen screen;
        if (this.mc.f_91080_ != null && (screen = this.mc.f_91080_) instanceof GuiScreenConfig && (gsc = (GuiScreenConfig)screen).isForBlock(pos.toBlock(), side)) {
            gsc.updateAutoVolume(av);
        }
    }

    @Override
    public void displaySetPadURLGui(ItemStack is, String padURL) {
        this.mc.m_91152_((Screen)new GuiSetURL2(is, padURL));
    }

    @Override
    public void openMinePadGui(UUID padId) {
        PadData pd = this.padMap.get(padId);
        if (pd != null && pd.view != null) {
            this.mc.m_91152_((Screen)new GuiMinePad(pd));
        }
    }

    @Override
    @Nonnull
    public HasAdvancement hasClientPlayerAdvancement(@Nonnull ResourceLocation rl) {
        if (this.advancementToProgressField != null && this.mc.f_91074_ != null && this.mc.f_91074_.f_108617_ != null) {
            ClientAdvancements cam = this.mc.f_91074_.f_108617_.m_105145_();
            Advancement adv = cam.m_104396_().m_139337_(rl);
            if (adv == null) {
                return HasAdvancement.DONT_KNOW;
            }
            if (this.lastAdvMgr != cam) {
                this.lastAdvMgr = cam;
                try {
                    this.advancementToProgress = (Map)this.advancementToProgressField.get(cam);
                }
                catch (Throwable t) {
                    Log.warningEx("Could not get ClientAdvancementManager.advancementToProgress field", t, new Object[0]);
                    this.advancementToProgress = null;
                    return HasAdvancement.DONT_KNOW;
                }
            }
            if (this.advancementToProgress == null) {
                return HasAdvancement.DONT_KNOW;
            }
            Object progress = this.advancementToProgress.get(adv);
            if (progress == null) {
                return HasAdvancement.NO;
            }
            if (!(progress instanceof AdvancementProgress)) {
                Log.warning("The ClientAdvancementManager.advancementToProgress map does not contain AdvancementProgress instances", new Object[0]);
                this.advancementToProgress = null;
                return HasAdvancement.DONT_KNOW;
            }
            return ((AdvancementProgress)progress).m_8193_() ? HasAdvancement.YES : HasAdvancement.NO;
        }
        return HasAdvancement.DONT_KNOW;
    }

    @Override
    public MinecraftServer getServer() {
        return this.mc.m_91092_();
    }

    @Override
    public void handleJSResponseSuccess(int reqId, JSServerRequest type, byte[] data) {
        JSQueryDispatcher.ServerQuery q = this.jsDispatcher.fulfillQuery(reqId);
        if (q == null) {
            Log.warning("Received success response for invalid query ID %d of type %s", reqId, type.toString());
        } else if (type == JSServerRequest.CLEAR_REDSTONE || type == JSServerRequest.SET_REDSTONE_AT) {
            q.success("{\"status\":\"success\"}");
        } else {
            Log.warning("Received success response for query ID %d, but type is invalid", reqId);
        }
    }

    @Override
    public void handleJSResponseError(int reqId, JSServerRequest type, int errCode, String err) {
        JSQueryDispatcher.ServerQuery q = this.jsDispatcher.fulfillQuery(reqId);
        if (q == null) {
            Log.warning("Received error response for invalid query ID %d of type %s", reqId, type.toString());
        } else {
            q.error(errCode, err);
        }
    }

    @Override
    public void setMiniservClientPort(int port) {
        this.miniservPort = port;
    }

    @Override
    public void startMiniservClient() {
        if (this.miniservPort <= 0) {
            Log.warning("Can't start miniserv client: miniserv is disabled", new Object[0]);
            return;
        }
        if (this.mc.f_91074_ == null) {
            Log.warning("Can't start miniserv client: player is null", new Object[0]);
            return;
        }
        SocketAddress saddr = this.mc.f_91074_.f_108617_.m_6198_().channel().remoteAddress();
        if (saddr == null || !(saddr instanceof InetSocketAddress)) {
            Log.warning("Miniserv client: remote address is not inet, assuming local address", new Object[0]);
            saddr = new InetSocketAddress("127.0.0.1", 1234);
        }
        InetSocketAddress msAddr = new InetSocketAddress(((InetSocketAddress)saddr).getAddress(), this.miniservPort);
        Client.getInstance().start(msAddr);
        this.msClientStarted = true;
    }

    @Override
    public boolean isMiniservDisabled() {
        return this.miniservPort <= 0;
    }

    @Override
    public void closeGui(BlockPos bp, BlockSide bs) {
        WDScreen scr;
        if (this.mc.f_91080_ instanceof WDScreen && (scr = (WDScreen)this.mc.f_91080_).isForBlock(bp, bs)) {
            this.mc.m_91152_(null);
        }
    }

    @Override
    public void renderRecipes() {
        this.nextScreen = new RenderRecipe();
    }

    @Override
    public boolean isShiftDown() {
        return Screen.m_96638_();
    }

    public void m_6213_(ResourceManager resourceManager) {
        Log.info("Resource manager reload: clearing GUI cache...", new Object[0]);
        GuiLoader.clearCache();
    }

    public void onAddressChange(IBrowser browser, String url) {
        if (browser != null) {
            long t = System.currentTimeMillis();
            for (PadData pd : this.padList) {
                if (pd.view != browser || t - pd.lastURLSent < 1000L) continue;
                if (WebDisplays.isSiteBlacklisted(url)) {
                    pd.view.loadURL("mod://webdisplays/blacklisted.html");
                    break;
                }
                pd.lastURLSent = t;
                WDNetworkRegistry.INSTANCE.sendToServer((Object)new C2SMessageMinepadUrl(pd.id, url));
                break;
            }
            for (TileEntityScreen tes : this.screenTracking) {
                tes.updateClientSideURL(browser, url);
            }
        }
    }

    public void onTitleChange(IBrowser browser, String title) {
    }

    public void onTooltip(IBrowser browser, String text) {
    }

    public void onStatusMessage(IBrowser browser, String value) {
    }

    public boolean handleQuery(IBrowser browser, long queryId, String query, boolean persistent, IJSQueryCallback cb) {
        if (browser != null && persistent && query != null && cb != null && (query = query.toLowerCase()).startsWith("webdisplays_")) {
            String args;
            int parenthesis = (query = query.substring(12)).indexOf(40);
            if (parenthesis < 0) {
                args = null;
            } else {
                if (query.indexOf(41) != query.length() - 1) {
                    cb.failure(400, "Malformed request");
                    return true;
                }
                args = query.substring(parenthesis + 1, query.length() - 1);
                query = query.substring(0, parenthesis);
            }
            if (this.jsDispatcher.canHandleQuery(query)) {
                this.jsDispatcher.enqueueQuery(browser, query, args, cb);
            } else {
                cb.failure(404, "Unknown WebDisplays query");
            }
            return true;
        }
        return false;
    }

    public void cancelQuery(IBrowser browser, long queryId) {
    }

    @SubscribeEvent
    public void onStitchTextures(TextureStitchEvent.Pre ev) {
        TextureAtlas texMap = ev.getAtlas();
        if (texMap.m_118330_().equals((Object)TextureAtlas.f_118259_)) {
            for (Material materialsSide : ScreenModelLoader.MATERIALS_SIDES) {
                ev.addSprite(materialsSide.m_119203_());
            }
        }
    }

    @SubscribeEvent
    public void onLevelTick(TickEvent.LevelTickEvent ev) {
        if (!ev.side.equals((Object)LogicalSide.CLIENT)) {
            return;
        }
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        if (this.mc.f_91074_ != null || !this.screenTracking.isEmpty()) {
            return;
        }
        int id = this.lastTracked % this.screenTracking.size();
        TileEntityScreen tes = this.screenTracking.get(id);
        if (!tes.m_58904_().equals(ev.level)) {
            return;
        }
        ++this.lastTracked;
        if (tes.m_58904_() != this.mc.f_91074_.f_19853_) {
            if (!tes.isLoaded()) {
                tes.load();
            }
        } else {
            double dist = Double.POSITIVE_INFINITY;
            for (int i = 0; i < tes.screenCount(); ++i) {
                TileEntityScreen.Screen scrn = tes.getScreen(i);
                Vector3d pos = new Vector3d((double)(scrn.side.right.x * scrn.size.x + scrn.size.y * scrn.side.up.x), (double)(scrn.side.right.y * scrn.size.x + scrn.size.y * scrn.side.up.y), (double)(scrn.side.right.z * scrn.size.x + scrn.size.y * scrn.side.up.z));
                double dist2 = this.mc.f_91074_.m_20275_(pos.f_86214_, pos.f_86215_, pos.f_86216_);
                dist = Math.min(dist, dist2);
            }
            if (tes.isLoaded()) {
                if (dist > WebDisplays.INSTANCE.unloadDistance2) {
                    tes.unload();
                } else if (ClientConfig.AutoVolumeControl.enableAutoVolume) {
                    tes.updateTrackDistance(dist, 80.0f);
                }
            } else if (dist <= WebDisplays.INSTANCE.loadDistance2) {
                tes.load();
            }
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)290)) {
            if (!this.isF1Down) {
                Object slot;
                this.isF1Down = true;
                String wikiName = null;
                if (this.mc.f_91080_ instanceof WDScreen) {
                    wikiName = ((WDScreen)this.mc.f_91080_).getWikiPageName();
                } else if (this.mc.f_91080_ instanceof AbstractContainerScreen && (slot = ((AbstractContainerScreen)this.mc.f_91080_).getSlotUnderMouse()) != null && slot.m_6657_() && slot.m_7993_().m_41720_() instanceof WDItem) {
                    wikiName = ((WDItem)slot.m_7993_().m_41720_()).getWikiName(slot.m_7993_());
                }
                if (wikiName != null) {
                    this.mcef.openExampleBrowser("https://montoyo.net/wdwiki/index.php/" + wikiName);
                }
            }
        } else if (this.isF1Down) {
            this.isF1Down = false;
        }
        if (this.nextScreen != null && this.mc.f_91080_ == null) {
            this.mc.m_91152_(this.nextScreen);
            this.nextScreen = null;
        }
        if (KEY_MOUSE.m_90857_()) {
            if (!rDown) {
                rDown = true;
                mouseOn = !mouseOn;
            }
        } else {
            rDown = false;
        }
        if (Minecraft.m_91087_().f_91074_ == null || !(Minecraft.m_91087_().f_91074_.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof ItemLaserPointer)) {
            mouseOn = false;
        }
        if (++this.minePadTickCounter >= 10) {
            this.minePadTickCounter = 0;
            LocalPlayer ep = this.mc.f_91074_;
            for (PadData pd : this.padList) {
                pd.isInHotbar = false;
            }
            if (ep != null) {
                this.updateInventory((NonNullList<ItemStack>)ep.m_150109_().f_35974_, ep.m_21120_(InteractionHand.MAIN_HAND), 9);
                this.updateInventory((NonNullList<ItemStack>)ep.m_150109_().f_35976_, ep.m_21120_(InteractionHand.OFF_HAND), 1);
            }
            for (int i = this.padList.size() - 1; i >= 0; --i) {
                PadData pd;
                pd = this.padList.get(i);
                if (pd.isInHotbar) continue;
                pd.view.close();
                pd.view = null;
                this.padList.remove(i);
                this.padMap.remove(pd.id);
            }
        }
        if (LaserPointerRenderer.isOn()) {
            ItemLaserPointer.tick(this.mc);
        } else {
            ItemLaserPointer.deselect(this.mc, this.jsDispatcher);
        }
        this.jsDispatcher.handleQueries();
        if (this.msClientStarted && this.mc.f_91074_ == null) {
            this.msClientStarted = false;
            Client.getInstance().stop();
        }
    }

    @SubscribeEvent
    public void onRenderPlayerHand(RenderHandEvent ev) {
        Item item = ev.getItemStack().m_41720_();
        if (ItemInit.MINEPAD.isPresent() && ItemInit.LASER_POINTER.isPresent()) {
            IItemRenderer renderer;
            if (item == ItemInit.MINEPAD.get()) {
                renderer = this.minePadRenderer;
            } else if (item == ItemInit.LASER_POINTER.get()) {
                renderer = this.laserPointerRenderer;
            } else {
                return;
            }
            HumanoidArm handSide = this.mc.f_91074_.m_5737_();
            if (ev.getHand() == InteractionHand.OFF_HAND) {
                handSide = handSide.m_20828_();
            }
            if (renderer.render(ev.getPoseStack(), ev.getItemStack(), handSide == HumanoidArm.RIGHT ? 1.0f : -1.0f, ev.getSwingProgress(), ev.getEquipProgress(), ev.getMultiBufferSource(), ev.getPackedLight())) {
                ev.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onWorldUnload(LevelEvent.Unload ev) {
        Log.info("World unloaded; killing screens...", new Object[0]);
        LevelAccessor levelAccessor = ev.getLevel();
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            ResourceLocation dim = level.m_46472_().m_135782_();
            for (int i = this.screenTracking.size() - 1; i >= 0; --i) {
                if (!this.screenTracking.get(i).m_58904_().m_46472_().m_135782_().equals((Object)dim)) continue;
                this.screenTracking.remove(i).unload();
            }
        }
    }

    public static BlockHitResult raycast(double dist) {
        Minecraft mc = Minecraft.m_91087_();
        Vec3 start = mc.f_91074_.m_20299_(1.0f);
        Vec3 lookVec = mc.f_91074_.m_20154_();
        Vec3 end = start.m_82520_(lookVec.f_82479_ * dist, lookVec.f_82480_ * dist, lookVec.f_82481_ * dist);
        return mc.f_91073_.m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, null));
    }

    private void updateInventory(NonNullList<ItemStack> inv, ItemStack heldStack, int cnt) {
        for (int i = 0; i < cnt; ++i) {
            CompoundTag tag;
            ItemStack item = (ItemStack)inv.get(i);
            if (!ItemInit.MINEPAD.isPresent() || item.m_41720_() != ItemInit.MINEPAD.get() || (tag = item.m_41783_()) == null || !tag.m_128441_("PadID")) continue;
            this.updatePad(tag.m_128342_("PadID"), tag, item == heldStack);
        }
    }

    private void updatePad(UUID id, CompoundTag tag, boolean isSelected) {
        PadData pd = this.padMap.get(id);
        if (pd != null) {
            pd.isInHotbar = true;
        } else if (isSelected && tag.m_128441_("PadURL")) {
            pd = new PadData(tag.m_128461_("PadURL"), id);
            this.padMap.put(id, pd);
            this.padList.add(pd);
        }
    }

    public MinePadRenderer getMinePadRenderer() {
        return this.minePadRenderer;
    }

    public PadData getPadByID(UUID id) {
        return this.padMap.get(id);
    }

    public API getMCEF() {
        return this.mcef;
    }

    public boolean findScreenFromBrowser(IBrowser browser, ScreenSidePair pair) {
        for (TileEntityScreen tes : this.screenTracking) {
            for (int i = 0; i < tes.screenCount(); ++i) {
                TileEntityScreen.Screen scr = tes.getScreen(i);
                if (scr.browser != browser) continue;
                pair.tes = tes;
                pair.side = scr.side;
                return true;
            }
        }
        return false;
    }

    private static Field findAdvancementToProgressField() {
        Field[] fields = ClientAdvancements.class.getDeclaredFields();
        Optional<Field> result = Arrays.stream(fields).filter(f -> f.getType() == Map.class).findAny();
        if (result.isPresent()) {
            try {
                Field ret = result.get();
                ret.setAccessible(true);
                return ret;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        Log.warning("ClientAdvancementManager.advancementToProgress field could not be found", new Object[0]);
        return null;
    }

    @Override
    public BlockGetter getWorld(NetworkEvent.Context context) {
        BlockGetter senderLevel = super.getWorld(context);
        if (senderLevel == null) {
            return Minecraft.m_91087_().f_91073_;
        }
        return senderLevel;
    }

    public static void onDrawSelection(RenderHighlightEvent event) {
        BlockHitResult bhr;
        BlockState state;
        Block block;
        HitResult hitResult = event.getTarget();
        if (hitResult instanceof BlockHitResult && (block = (state = Minecraft.m_91087_().f_91073_.m_8055_((bhr = (BlockHitResult)hitResult).m_82425_())).m_60734_()) instanceof BlockScreen) {
            TileEntityScreen tes;
            BlockScreen screen = (BlockScreen)block;
            Vector3i vec = new Vector3i(bhr.m_82425_().m_123341_(), bhr.m_82425_().m_123342_(), bhr.m_82425_().m_123343_());
            BlockSide side = BlockSide.fromInt(bhr.m_82434_().ordinal());
            Multiblock.findOrigin((LevelAccessor)Minecraft.m_91087_().f_91073_, vec, side, null);
            BlockPos pos = new BlockPos(vec.x, vec.y, vec.z);
            BlockEntity be = Minecraft.m_91087_().f_91073_.m_7702_(pos);
            if (be instanceof TileEntityScreen && (tes = (TileEntityScreen)be).getScreen(side) != null) {
                event.setCanceled(true);
            }
        }
    }

    public static void onKeybindRegistry(RegisterKeyMappingsEvent event) {
        event.register(KEY_MOUSE);
    }

    static {
        KEY_MOUSE = new KeyMapping("webdisplays.key.toggle_mouse", 82, "key.categories.misc");
        rDown = false;
        mouseOn = false;
    }

    public class PadData {
        public IBrowser view;
        private boolean isInHotbar;
        private final UUID id;
        private long lastURLSent;

        private PadData(String url, UUID id) {
            String webUrl;
            try {
                webUrl = TileEntityScreen.url(url);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.view = ClientProxy.this.mcef.createBrowser(WebDisplays.applyBlacklist(webUrl));
            this.view.resize((int)WebDisplays.INSTANCE.padResX, (int)WebDisplays.INSTANCE.padResY);
            this.isInHotbar = true;
            this.id = id;
        }
    }

    public static final class ScreenSidePair {
        public TileEntityScreen tes;
        public BlockSide side;
    }
}

